/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class DyeBottleRecipe
extends CustomRecipe {
    public DyeBottleRecipe(ResourceLocation resourceLocation, CraftingBookCategory category) {
        super(resourceLocation, category);
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        boolean hasDye = false;
        boolean hasDyableItem = false;
        for (ItemStack itemstack : craftingContainer.m_280657_()) {
            if (itemstack.m_41619_()) continue;
            Item item = itemstack.m_41720_();
            if (item == ModRegistry.DYE_BOTTLE_ITEM.get()) {
                if (hasDye) {
                    return false;
                }
                hasDye = true;
                continue;
            }
            if (!(item instanceof DyeableLeatherItem) && (BlocksColorAPI.getKey((Item)item) == null || !BlocksColorAPI.isDefaultColor((Item)item))) continue;
            if (hasDyableItem) {
                return false;
            }
            hasDyableItem = true;
        }
        return hasDye && hasDyableItem;
    }

    public ItemStack assemble(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        ItemStack result;
        ItemStack leather = ItemStack.f_41583_;
        ItemStack dyeBottle = ItemStack.f_41583_;
        for (ItemStack itemstack : craftingContainer.m_280657_()) {
            if (itemstack.m_41619_()) continue;
            Item item = itemstack.m_41720_();
            if (item == ModRegistry.DYE_BOTTLE_ITEM.get()) {
                dyeBottle = itemstack;
                continue;
            }
            leather = itemstack;
        }
        Item item = leather.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            DyeableLeatherItem l = (DyeableLeatherItem)item;
            result = leather.m_41777_();
            l.m_41115_(result, DyeBottleItem.mixColor(DyeBottleItem.getColor(dyeBottle), l.m_41121_(leather), 1, 1));
        } else {
            result = BlocksColorAPI.changeColor((Item)leather.m_41720_(), (DyeColor)DyeBottleItem.getClosestDye(dyeBottle)).m_7968_();
        }
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 2;
    }

    public String m_6076_() {
        return "dye_bottle";
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.DYE_BOTTLE_RECIPE.get();
    }
}

