/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import net.mehvahdjukaar.amendments.common.CakeRegistry;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.FarmersDelightCompat;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DirectionalCakeBlock
extends CakeBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape[] SHAPES_NORTH = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0)};
    protected static final VoxelShape[] SHAPES_SOUTH = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)13.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)11.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)9.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)7.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)5.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0)};
    protected static final VoxelShape[] SHAPES_EAST = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)11.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)9.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)7.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)15.0)};
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public final CakeRegistry.CakeType type;

    public DirectionalCakeBlock(CakeRegistry.CakeType type) {
        super(Utils.copyPropertySafe((Block)type.cake).m_60916_(type.cake));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_51180_, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.WEST)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return this.useGeneric(state, level, pos, player, handIn, hit, true);
    }

    protected InteractionResult useGeneric(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, boolean canEat) {
        Block block;
        InteractionResult res;
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (CompatHandler.FARMERS_DELIGHT && this.type == CakeRegistry.VANILLA && (res = FarmersDelightCompat.onCakeInteract(state, pos, level, itemstack)).m_19077_()) {
            return res;
        }
        if (itemstack.m_204117_(ItemTags.f_144319_) && (Integer)state.m_61143_((Property)f_51180_) == 0 && state.m_60713_(ModRegistry.DIRECTIONAL_CAKE.get()) && (block = Block.m_49814_((Item)item)) instanceof CandleBlock) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            level.m_5594_(null, pos, SoundEvents.f_144090_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46597_(pos, CandleCakeBlock.m_152865_((Block)block));
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.SUCCESS;
        }
        if (!canEat) {
            return InteractionResult.PASS;
        }
        return this.eatSliceD((LevelAccessor)level, pos, state, player, DirectionalCakeBlock.getHitDir(player, hit));
    }

    public static Direction getHitDir(Player player, BlockHitResult hit) {
        return hit.m_82434_().m_122434_() != Direction.Axis.Y ? hit.m_82434_() : player.m_6350_().m_122424_();
    }

    public InteractionResult eatSliceD(LevelAccessor world, BlockPos pos, BlockState state, Player player, Direction dir) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        player.m_36324_().m_38707_(2, 0.1f);
        if (!world.m_5776_()) {
            this.removeSlice(state, pos, world, dir);
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public void removeSlice(BlockState state, BlockPos pos, LevelAccessor world, Direction dir) {
        int i = (Integer)state.m_61143_((Property)f_51180_);
        if (i < 6) {
            if (i == 0 && CommonConfigs.DIRECTIONAL_CAKE.get().booleanValue()) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)dir);
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51180_, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.m_7471_(pos, false);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Items.f_42502_);
    }

    public MutableComponent m_49954_() {
        return Blocks.f_50145_.m_49954_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, f_51180_, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> f_51181_[(Integer)state.m_61143_((Property)f_51180_)];
            case Direction.EAST -> SHAPES_EAST[(Integer)state.m_61143_((Property)f_51180_)];
            case Direction.SOUTH -> SHAPES_SOUTH[(Integer)state.m_61143_((Property)f_51180_)];
            case Direction.NORTH -> SHAPES_NORTH[(Integer)state.m_61143_((Property)f_51180_)];
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (CompatHandler.SUPPLEMENTARIES) {
            SuppCompat.spawnCakeParticles(level, pos, rand);
        }
    }
}

