/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.terminal;

import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;

public class TerminalState {
    public final boolean colour;
    public final int width;
    public final int height;
    @Nullable
    private final ByteBuf buffer;

    public TerminalState(@Nullable NetworkedTerminal terminal) {
        if (terminal == null) {
            this.colour = false;
            this.height = 0;
            this.width = 0;
            this.buffer = null;
        } else {
            this.colour = terminal.isColour();
            this.width = terminal.getWidth();
            this.height = terminal.getHeight();
            ByteBuf buf = this.buffer = Unpooled.buffer();
            terminal.write(new FriendlyByteBuf(buf));
        }
    }

    public TerminalState(FriendlyByteBuf buf) {
        this.colour = buf.readBoolean();
        if (buf.readBoolean()) {
            this.width = buf.m_130242_();
            this.height = buf.m_130242_();
            int length = buf.m_130242_();
            this.buffer = buf.readBytes(length);
        } else {
            this.height = 0;
            this.width = 0;
            this.buffer = null;
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.colour);
        buf.writeBoolean(this.buffer != null);
        if (this.buffer != null) {
            buf.m_130130_(this.width);
            buf.m_130130_(this.height);
            buf.m_130130_(this.buffer.readableBytes());
            buf.writeBytes(this.buffer, this.buffer.readerIndex(), this.buffer.readableBytes());
        }
    }

    public boolean hasTerminal() {
        return this.buffer != null;
    }

    public int size() {
        return this.buffer == null ? 0 : this.buffer.readableBytes();
    }

    public void apply(NetworkedTerminal terminal) {
        if (this.buffer == null) {
            throw new NullPointerException("buffer");
        }
        terminal.resize(this.width, this.height);
        terminal.read(new FriendlyByteBuf(this.buffer));
    }

    public NetworkedTerminal create() {
        if (this.buffer == null) {
            throw new NullPointerException("Terminal does not exist");
        }
        NetworkedTerminal terminal = new NetworkedTerminal(this.width, this.height, this.colour);
        terminal.read(new FriendlyByteBuf(this.buffer));
        return terminal;
    }
}

