/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.util;

import javax.annotation.Nullable;

public enum Colour {
    BLACK(0x111111),
    RED(0xCC4C4C),
    GREEN(5744206),
    BROWN(8349260),
    BLUE(0x3366CC),
    PURPLE(11691749),
    CYAN(5020082),
    LIGHT_GREY(0x999999),
    GREY(0x4C4C4C),
    PINK(15905484),
    LIME(8375321),
    YELLOW(14605932),
    LIGHT_BLUE(10072818),
    MAGENTA(15040472),
    ORANGE(15905331),
    WHITE(0xF0F0F0);

    public static final Colour[] VALUES;
    private final int hex;
    private final float red;
    private final float green;
    private final float blue;

    public static Colour fromInt(int colour) {
        return VALUES[colour];
    }

    @Nullable
    public static Colour fromHex(int colour) {
        for (Colour entry : VALUES) {
            if (entry.getHex() != colour) continue;
            return entry;
        }
        return null;
    }

    private Colour(int hex) {
        this.hex = hex;
        this.red = (float)(hex >> 16 & 0xFF) / 255.0f;
        this.green = (float)(hex >> 8 & 0xFF) / 255.0f;
        this.blue = (float)(hex & 0xFF) / 255.0f;
    }

    public Colour getNext() {
        return VALUES[(this.ordinal() + 1) % 16];
    }

    public Colour getPrevious() {
        return VALUES[(this.ordinal() + 15) % 16];
    }

    public int getHex() {
        return this.hex;
    }

    public float getR() {
        return this.red;
    }

    public float getG() {
        return this.green;
    }

    public float getB() {
        return this.blue;
    }

    static {
        VALUES = Colour.values();
    }
}

