/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.WorkMonitor;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.computer.GlobalEnvironment;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.core.terminal.Terminal;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class Environment
implements IAPIEnvironment {
    private final Computer computer;
    private final ComputerEnvironment environment;
    private final MetricsObserver metrics;
    private boolean internalOutputChanged = false;
    private final int[] internalOutput = new int[6];
    private final int[] internalBundledOutput = new int[6];
    private final int[] externalOutput = new int[6];
    private final int[] externalBundledOutput = new int[6];
    private boolean inputChanged = false;
    private final int[] input = new int[6];
    private final int[] bundledInput = new int[6];
    private final IPeripheral[] peripherals = new IPeripheral[6];
    @Nullable
    private IAPIEnvironment.IPeripheralChangeListener peripheralListener = null;
    private final Int2ObjectMap<Timer> timers = new Int2ObjectOpenHashMap();
    private int nextTimerToken = 0;

    Environment(Computer computer, ComputerEnvironment environment) {
        this.computer = computer;
        this.environment = environment;
        this.metrics = environment.getMetrics();
    }

    @Override
    public int getComputerID() {
        return this.computer.getID();
    }

    @Override
    public ComputerEnvironment getComputerEnvironment() {
        return this.environment;
    }

    @Override
    public GlobalEnvironment getGlobalEnvironment() {
        return this.computer.getGlobalEnvironment();
    }

    @Override
    public WorkMonitor getMainThreadMonitor() {
        return this.computer.getMainThreadMonitor();
    }

    @Override
    public Terminal getTerminal() {
        return this.computer.getTerminal();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.computer.getFileSystem();
    }

    @Override
    public void shutdown() {
        this.computer.shutdown();
    }

    @Override
    public void reboot() {
        this.computer.reboot();
    }

    @Override
    public void queueEvent(String event, Object ... args) {
        this.computer.queueEvent(event, args);
    }

    @Override
    public int getInput(ComputerSide side) {
        return this.input[side.ordinal()];
    }

    @Override
    public int getBundledInput(ComputerSide side) {
        return this.bundledInput[side.ordinal()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutput(ComputerSide side, int output) {
        int index = side.ordinal();
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            if (this.internalOutput[index] != output) {
                this.internalOutput[index] = output;
                this.internalOutputChanged = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutput(ComputerSide side) {
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.computer.isOn() ? this.internalOutput[side.ordinal()] : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundledOutput(ComputerSide side, int output) {
        int index = side.ordinal();
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            if (this.internalBundledOutput[index] != output) {
                this.internalBundledOutput[index] = output;
                this.internalOutputChanged = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBundledOutput(ComputerSide side) {
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.computer.isOn() ? this.internalBundledOutput[side.ordinal()] : 0;
        }
    }

    public int getExternalRedstoneOutput(ComputerSide side) {
        return this.computer.isOn() ? this.externalOutput[side.ordinal()] : 0;
    }

    public int getExternalBundledRedstoneOutput(ComputerSide side) {
        return this.computer.isOn() ? this.externalBundledOutput[side.ordinal()] : 0;
    }

    public void setRedstoneInput(ComputerSide side, int level) {
        int index = side.ordinal();
        if (this.input[index] != level) {
            this.input[index] = level;
            this.inputChanged = true;
        }
    }

    public void setBundledRedstoneInput(ComputerSide side, int combination) {
        int index = side.ordinal();
        if (this.bundledInput[index] != combination) {
            this.bundledInput[index] = combination;
            this.inputChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Int2ObjectMap<Timer> int2ObjectMap = this.timers;
        synchronized (int2ObjectMap) {
            this.timers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tick() {
        if (this.inputChanged) {
            this.inputChanged = false;
            this.queueEvent("redstone", new Object[0]);
        }
        Int2ObjectMap<Timer> int2ObjectMap = this.timers;
        synchronized (int2ObjectMap) {
            ObjectIterator it = this.timers.int2ObjectEntrySet().iterator();
            while (it.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)it.next();
                Timer timer = (Timer)entry.getValue();
                --timer.ticksLeft;
                if (timer.ticksLeft > 0L) continue;
                this.queueEvent("timer", entry.getIntKey());
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateOutput() {
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            if (!this.internalOutputChanged) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            boolean changed = false;
            for (int i = 0; i < 6; ++i) {
                if (this.externalOutput[i] != this.internalOutput[i]) {
                    this.externalOutput[i] = this.internalOutput[i];
                    changed = true;
                }
                if (this.externalBundledOutput[i] == this.internalBundledOutput[i]) continue;
                this.externalBundledOutput[i] = this.internalBundledOutput[i];
                changed = true;
            }
            this.internalOutputChanged = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetOutput() {
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            Arrays.fill(this.internalOutput, 0);
            Arrays.fill(this.internalBundledOutput, 0);
            this.internalOutputChanged = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public IPeripheral getPeripheral(ComputerSide side) {
        IPeripheral[] iPeripheralArray = this.peripherals;
        synchronized (this.peripherals) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.peripherals[side.ordinal()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeripheral(ComputerSide side, @Nullable IPeripheral peripheral) {
        IPeripheral[] iPeripheralArray = this.peripherals;
        synchronized (this.peripherals) {
            int index = side.ordinal();
            IPeripheral existing = this.peripherals[index];
            if (existing == null && peripheral != null || existing != null && peripheral == null || existing != null && !existing.equals(peripheral)) {
                this.peripherals[index] = peripheral;
                if (this.peripheralListener != null) {
                    this.peripheralListener.onPeripheralChanged(side, peripheral);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPeripheralChangeListener(@Nullable IAPIEnvironment.IPeripheralChangeListener listener) {
        IPeripheral[] iPeripheralArray = this.peripherals;
        synchronized (this.peripherals) {
            this.peripheralListener = listener;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    @Nullable
    public String getLabel() {
        return this.computer.getLabel();
    }

    @Override
    public void setLabel(@Nullable String label) {
        this.computer.setLabel(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startTimer(long ticks) {
        Int2ObjectMap<Timer> int2ObjectMap = this.timers;
        synchronized (int2ObjectMap) {
            this.timers.put(this.nextTimerToken, (Object)new Timer(ticks));
            return this.nextTimerToken++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTimer(int id) {
        Int2ObjectMap<Timer> int2ObjectMap = this.timers;
        synchronized (int2ObjectMap) {
            this.timers.remove(id);
        }
    }

    @Override
    public MetricsObserver metrics() {
        return this.metrics;
    }

    private static class Timer {
        long ticksLeft;

        Timer(long ticksLeft) {
            this.ticksLeft = ticksLeft;
        }
    }
}

