/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import dan200.computercraft.api.lua.Coerced;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.core.asm.Reflect;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Generator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Generator.class);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle METHOD_RESULT_OF_VOID;
    private static final MethodHandle METHOD_RESULT_OF_ONE;
    private static final MethodHandle METHOD_RESULT_OF_MANY;
    private static final Map<Class<?>, ArgMethods> argMethods;
    private static final ArgMethods ARG_TABLE_UNSAFE;
    private static final MethodHandle ARG_GET_OBJECT;
    private static final MethodHandle ARG_GET_ENUM;
    private static final MethodHandle ARG_OPT_ENUM;
    private static final MethodHandle ARG_GET_STRING_COERCED;
    private static final MethodHandle ARG_GET_BYTES_COERCED;
    private final List<Class<?>> context;
    private final List<Class<?>> contextWithArguments;
    private final MethodHandle argumentGetter;
    private final List<MethodHandle> contextGetters;
    private final java.util.function.Function<MethodHandle, T> factory;
    private final java.util.function.Function<T, T> wrap;
    private final LoadingCache<Method, Optional<T>> instanceCache = CacheBuilder.newBuilder().build(CacheLoader.from(Generator.catching(this::buildInstanceMethod, Optional.empty())));
    private final LoadingCache<GenericMethod, Optional<T>> genericCache = CacheBuilder.newBuilder().weakKeys().build(CacheLoader.from(Generator.catching(this::buildGenericMethod, Optional.empty())));

    static void addArgType(Map<Class<?>, ArgMethods> types, Class<?> type, String name) throws ReflectiveOperationException {
        types.put(type, ArgMethods.of(type, name));
    }

    Generator(List<Class<?>> context, java.util.function.Function<MethodHandle, T> factory, java.util.function.Function<T, T> wrap) {
        this.context = context;
        this.factory = factory;
        this.wrap = wrap;
        this.contextWithArguments = new ArrayList(context.size() + 1);
        ArrayList contextWithArguments = this.contextWithArguments;
        contextWithArguments.addAll(context);
        contextWithArguments.add(IArguments.class);
        this.argumentGetter = MethodHandles.dropArguments(MethodHandles.identity(IArguments.class), 0, context);
        this.contextGetters = new ArrayList<MethodHandle>(context.size());
        ArrayList<MethodHandle> contextGetters = this.contextGetters;
        for (int i = 0; i < context.size(); ++i) {
            MethodHandle getter = MethodHandles.identity(context.get(i));
            if (i > 0) {
                getter = MethodHandles.dropArguments(getter, 0, contextWithArguments.subList(0, i));
            }
            contextGetters.add(getter);
        }
    }

    Optional<T> getInstanceMethod(Method method) {
        return (Optional)this.instanceCache.getUnchecked((Object)method);
    }

    Optional<T> getGenericMethod(GenericMethod method) {
        return (Optional)this.genericCache.getUnchecked((Object)method);
    }

    private boolean checkMethod(Method method) {
        Class<?>[] exceptions;
        if (method.isBridge()) {
            LOG.debug("Skipping bridge Lua Method {}.{}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return false;
        }
        for (Class<?> exception : exceptions = method.getExceptionTypes()) {
            if (exception == LuaException.class) continue;
            LOG.error("Lua Method {}.{} cannot throw {}.", new Object[]{method.getDeclaringClass().getName(), method.getName(), exception.getName()});
            return false;
        }
        LuaFunction annotation = method.getAnnotation(LuaFunction.class);
        if (annotation.unsafe() && annotation.mainThread()) {
            LOG.error("Lua Method {}.{} cannot use unsafe and mainThread.", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return false;
        }
        int modifiers = method.getModifiers();
        if (!(Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isFinal(method.getDeclaringClass().getModifiers()))) {
            LOG.warn("Lua Method {}.{} should be final.", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        }
        return true;
    }

    private Optional<T> buildInstanceMethod(Method method) {
        if (!this.checkMethod(method)) {
            return Optional.empty();
        }
        MethodHandle handle = Generator.tryUnreflect(method);
        if (handle == null) {
            return Optional.empty();
        }
        return this.build(method, handle, Arrays.asList(method.getGenericParameterTypes()));
    }

    private Optional<T> buildGenericMethod(GenericMethod method) {
        if (!this.checkMethod(method.method)) {
            return Optional.empty();
        }
        MethodHandle handle = Generator.tryUnreflect(method.method);
        if (handle == null) {
            return Optional.empty();
        }
        List<Type> parameters = Arrays.asList(method.method.getGenericParameterTypes());
        return this.build(method.method, Modifier.isStatic(method.method.getModifiers()) ? handle : handle.bindTo(method.source), parameters.subList(1, parameters.size()));
    }

    private Optional<T> build(Method method, MethodHandle handle, List<Type> parameters) {
        LOG.debug("Generating method wrapper for {}.{}.", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        LuaFunction annotation = method.getAnnotation(LuaFunction.class);
        MethodHandle wrappedHandle = this.buildMethodHandle(method, handle, parameters, annotation.unsafe());
        if (wrappedHandle == null) {
            return Optional.empty();
        }
        T instance = this.factory.apply(wrappedHandle);
        return Optional.of(annotation.mainThread() ? this.wrap.apply(instance) : instance);
    }

    @Nullable
    private MethodHandle buildMethodHandle(Member method, MethodHandle handle, List<Type> parameterTypes, boolean unsafe) {
        if (handle.type().parameterCount() != parameterTypes.size() + 1) {
            throw new IllegalArgumentException("Argument lists are mismatched");
        }
        handle = MethodHandles.dropArguments(handle, handle.type().parameterCount(), this.contextWithArguments);
        int argCount = 0;
        ArrayList<MethodHandle> argSelectors = new ArrayList<MethodHandle>(parameterTypes.size());
        for (Type paramType : parameterTypes) {
            MethodHandle argSelector;
            Class<?> paramClass = Reflect.getRawType(method, paramType, true);
            if (paramClass == null) {
                return null;
            }
            if (paramClass == IArguments.class) {
                argSelector = this.argumentGetter;
            } else {
                int idx = this.context.indexOf(paramClass);
                if (idx >= 0) {
                    argSelector = this.contextGetters.get(idx);
                } else {
                    MethodHandle selector;
                    if ((selector = Generator.loadArg(method, unsafe, paramClass, paramType, argCount++)) == null) {
                        return null;
                    }
                    argSelector = MethodHandles.filterReturnValue(this.argumentGetter, selector);
                }
            }
            argSelectors.add(argSelector);
        }
        for (int i = parameterTypes.size() - 1; i >= 0; --i) {
            handle = MethodHandles.foldArguments(handle, i + 1, (MethodHandle)argSelectors.get(i));
        }
        MethodType type = (handle = handle.asType(handle.type().changeParameterType(0, Object.class))).type();
        TypeDescriptor.OfField ret = type.returnType();
        if (ret == MethodResult.class) {
            return handle;
        }
        if (ret == Void.TYPE) {
            return MethodHandles.filterReturnValue(handle, METHOD_RESULT_OF_VOID);
        }
        if (ret == Object[].class) {
            return MethodHandles.filterReturnValue(handle, METHOD_RESULT_OF_MANY);
        }
        return MethodHandles.filterReturnValue(handle.asType(type.changeReturnType(Object.class)), METHOD_RESULT_OF_ONE);
    }

    @Nullable
    private static MethodHandle loadArg(Member method, boolean unsafe, Class<?> argType, Type genericArg, int argIndex) {
        if (argType == Coerced.class) {
            Class<?> klass = Reflect.getRawType(method, TypeToken.of((Type)genericArg).resolveType(Reflect.COERCED_IN).getType(), false);
            if (klass == null) {
                return null;
            }
            if (klass == String.class) {
                return MethodHandles.insertArguments(ARG_GET_STRING_COERCED, 1, argIndex);
            }
            if (klass == ByteBuffer.class) {
                return MethodHandles.insertArguments(ARG_GET_BYTES_COERCED, 1, argIndex);
            }
        }
        if (argType == Optional.class) {
            Class<?> optType = Reflect.getRawType(method, TypeToken.of((Type)genericArg).resolveType(Reflect.OPTIONAL_IN).getType(), false);
            if (optType == null) {
                return null;
            }
            if (Enum.class.isAssignableFrom(optType) && optType != Enum.class) {
                return MethodHandles.insertArguments(ARG_OPT_ENUM, 1, argIndex, optType);
            }
            ArgMethods getter = Generator.getArgMethods(Primitives.unwrap(optType), unsafe);
            if (getter != null) {
                return MethodHandles.insertArguments(getter.opt(), 1, argIndex);
            }
        }
        if (Enum.class.isAssignableFrom(argType) && argType != Enum.class) {
            return Generator.setReturn(MethodHandles.insertArguments(ARG_GET_ENUM, 1, argIndex, argType), argType);
        }
        if (argType == Object.class) {
            return MethodHandles.insertArguments(ARG_GET_OBJECT, 1, argIndex);
        }
        if (Reflect.getRawType(method, genericArg, false) == null) {
            return null;
        }
        ArgMethods getter = Generator.getArgMethods(argType, unsafe);
        if (getter != null) {
            return MethodHandles.insertArguments(getter.get(), 1, argIndex);
        }
        LOG.error("Unknown parameter type {} for method {}.{}.", new Object[]{argType.getName(), method.getDeclaringClass().getName(), method.getName()});
        return null;
    }

    private static MethodHandle setReturn(MethodHandle handle, Class<?> retTy) {
        return handle.asType(handle.type().changeReturnType(retTy));
    }

    @Nullable
    private static ArgMethods getArgMethods(Class<?> type, boolean unsafe) {
        ArgMethods getter = argMethods.get(type);
        if (getter != null) {
            return getter;
        }
        if (type == LuaTable.class && unsafe) {
            return ARG_TABLE_UNSAFE;
        }
        return null;
    }

    @Nullable
    private static MethodHandle tryUnreflect(Method method) {
        try {
            method.setAccessible(true);
            return LOOKUP.unreflect(method);
        }
        catch (IllegalAccessException | SecurityException | InaccessibleObjectException e) {
            LOG.error("Lua Method {}.{} is not accessible.", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
            return null;
        }
    }

    static <T, U> Function<T, U> catching(java.util.function.Function<T, U> function, U def) {
        return x -> {
            try {
                return function.apply(x);
            }
            catch (Exception | LinkageError e) {
                LOG.error("Error generating @LuaFunction for {}", x, (Object)e);
                return def;
            }
        };
    }

    static {
        try {
            METHOD_RESULT_OF_VOID = LOOKUP.findStatic(MethodResult.class, "of", MethodType.methodType(MethodResult.class));
            METHOD_RESULT_OF_ONE = LOOKUP.findStatic(MethodResult.class, "of", MethodType.methodType(MethodResult.class, Object.class));
            METHOD_RESULT_OF_MANY = LOOKUP.findStatic(MethodResult.class, "of", MethodType.methodType(MethodResult.class, Object[].class));
            HashMap argMethodMap = new HashMap();
            Generator.addArgType(argMethodMap, Integer.TYPE, "Int");
            Generator.addArgType(argMethodMap, Boolean.TYPE, "Boolean");
            Generator.addArgType(argMethodMap, Double.TYPE, "Double");
            Generator.addArgType(argMethodMap, Long.TYPE, "Long");
            Generator.addArgType(argMethodMap, Map.class, "Table");
            Generator.addArgType(argMethodMap, String.class, "String");
            Generator.addArgType(argMethodMap, ByteBuffer.class, "Bytes");
            argMethods = Map.copyOf(argMethodMap);
            ARG_TABLE_UNSAFE = ArgMethods.of(LuaTable.class, "TableUnsafe");
            ARG_GET_OBJECT = LOOKUP.findVirtual(IArguments.class, "get", MethodType.methodType(Object.class, Integer.TYPE));
            ARG_GET_ENUM = LOOKUP.findVirtual(IArguments.class, "getEnum", MethodType.methodType(Enum.class, Integer.TYPE, Class.class));
            ARG_OPT_ENUM = LOOKUP.findVirtual(IArguments.class, "optEnum", MethodType.methodType(Optional.class, Integer.TYPE, Class.class));
            MethodHandle mkCoerced = LOOKUP.findConstructor(Coerced.class, MethodType.methodType(Void.TYPE, Object.class));
            ARG_GET_STRING_COERCED = MethodHandles.filterReturnValue(Generator.setReturn(LOOKUP.findVirtual(IArguments.class, "getStringCoerced", MethodType.methodType(String.class, Integer.TYPE)), Object.class), mkCoerced);
            ARG_GET_BYTES_COERCED = MethodHandles.filterReturnValue(Generator.setReturn(LOOKUP.findVirtual(IArguments.class, "getBytesCoerced", MethodType.methodType(ByteBuffer.class, Integer.TYPE)), Object.class), mkCoerced);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private record ArgMethods(MethodHandle get, MethodHandle opt) {
        public static ArgMethods of(Class<?> type, String name) throws ReflectiveOperationException {
            return new ArgMethods(LOOKUP.findVirtual(IArguments.class, "get" + name, MethodType.methodType(type, Integer.TYPE)), LOOKUP.findVirtual(IArguments.class, "opt" + name, MethodType.methodType(Optional.class, Integer.TYPE)));
        }
    }
}

