/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.options;

import com.google.errorprone.annotations.Immutable;
import dan200.computercraft.core.apis.http.options.Action;
import dan200.computercraft.core.apis.http.options.Options;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nullable;

@Immutable
public final class PartialOptions {
    public static final PartialOptions DEFAULT = new PartialOptions(null, OptionalLong.empty(), OptionalLong.empty(), OptionalInt.empty(), Optional.empty());
    @Nullable
    private final Action action;
    private final OptionalLong maxUpload;
    private final OptionalLong maxDownload;
    private final OptionalInt websocketMessage;
    private final Optional<Boolean> useProxy;
    @Nullable
    private Options options;

    public PartialOptions(@Nullable Action action, OptionalLong maxUpload, OptionalLong maxDownload, OptionalInt websocketMessage, Optional<Boolean> useProxy) {
        this.action = action;
        this.maxUpload = maxUpload;
        this.maxDownload = maxDownload;
        this.websocketMessage = websocketMessage;
        this.useProxy = useProxy;
    }

    public Options toOptions() {
        if (this.options != null) {
            return this.options;
        }
        this.options = new Options(this.action == null ? Action.DENY : this.action, this.maxUpload.orElse(0x400000L), this.maxDownload.orElse(0x1000000L), this.websocketMessage.orElse(131072), this.useProxy.orElse(false));
        return this.options;
    }

    PartialOptions merge(PartialOptions other) {
        if (this == DEFAULT) {
            return other;
        }
        return new PartialOptions(this.action == null && other.action != null ? other.action : this.action, this.maxUpload.isPresent() ? this.maxUpload : other.maxUpload, this.maxDownload.isPresent() ? this.maxDownload : other.maxDownload, this.websocketMessage.isPresent() ? this.websocketMessage : other.websocketMessage, this.useProxy.isPresent() ? this.useProxy : other.useProxy);
    }
}

