/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_markers;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.SliceMapItem;
import net.mehvahdjukaar.supplementaries.common.misc.ColoredMapHandler;
import net.mehvahdjukaar.supplementaries.common.misc.MapLightHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class WeatheredMap {
    private static final String ANTIQUE_KEY = "antique";
    private static final CustomMapData.Type<WeatheredMapData> ANTIQUE_DATA_KEY;
    public static final MapColor ANTIQUE_LIGHT;
    public static final MapColor ANTIQUE_DARK;
    private static final Object2ObjectArrayMap<MapColor, MapColor> ANTIQUE_COLORS;

    public static void init() {
    }

    public static WeatheredMapData getAntiqueData(MapItemSavedData data) {
        return (WeatheredMapData)ANTIQUE_DATA_KEY.get(data);
    }

    public static void setAntique(Level level, ItemStack stack, boolean on) {
        WeatheredMap.setAntique(level, stack, on, false);
    }

    public static void setAntique(Level level, ItemStack stack, boolean on, boolean replaceOld) {
        MapItemSavedData mapitemsaveddata = MapItem.m_42853_((ItemStack)stack, (Level)level);
        Integer mapId = WeatheredMap.createAntiqueMapData(mapitemsaveddata, level, on, replaceOld);
        if (mapId != null) {
            stack.m_41784_().m_128405_("map", mapId.intValue());
        }
    }

    public static Integer createAntiqueMapData(MapItemSavedData mapitemsaveddata, Level level, boolean on, boolean replaceOld) {
        if (mapitemsaveddata instanceof ExpandedMapData) {
            ExpandedMapData data = (ExpandedMapData)mapitemsaveddata;
            MapItemSavedData newData = replaceOld ? mapitemsaveddata : data.copy();
            WeatheredMapData instance = WeatheredMap.getAntiqueData(newData);
            ColoredMapHandler.ColorData colorData = ColoredMapHandler.getColorData(newData);
            colorData.clear();
            MapLightHandler.LightData lightData = MapLightHandler.getLightData(newData);
            lightData.clear();
            instance.set(on);
            instance.setDirty(newData, CustomMapData.SimpleDirtyCounter::markDirty);
            if (!replaceOld) {
                int mapId = level.m_7354_();
                String mapKey = MapItem.m_42848_((int)mapId);
                level.m_142325_(mapKey, newData);
                return mapId;
            }
        }
        return null;
    }

    static {
        MapColor mc1;
        MapColor mc;
        ANTIQUE_DATA_KEY = MapDataRegistry.registerCustomMapSavedData((ResourceLocation)Supplementaries.res(ANTIQUE_KEY), WeatheredMapData::new);
        ANTIQUE_COLORS = new Object2ObjectArrayMap();
        try {
            Class<MapColor> cl = MapColor.class;
            Constructor cons = cl.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
            cons.setAccessible(true);
            mc = (MapColor)cons.newInstance(62, 13870193);
            mc1 = (MapColor)cons.newInstance(63, 10976850);
        }
        catch (Exception e) {
            mc = MapColor.f_283919_;
            mc1 = MapColor.f_283877_;
            Supplementaries.LOGGER.warn("Failed to add custom map colors for antique map: " + e);
        }
        ANTIQUE_DARK = mc1;
        ANTIQUE_LIGHT = mc;
        ANTIQUE_COLORS.put((Object)MapColor.f_283947_, (Object)MapColor.f_283762_);
        ANTIQUE_COLORS.put((Object)MapColor.f_283875_, (Object)MapColor.f_283762_);
        ANTIQUE_COLORS.put((Object)MapColor.f_283915_, (Object)MapColor.f_283748_);
        ANTIQUE_COLORS.put((Object)MapColor.f_283762_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.f_283825_, (Object)MapColor.f_283825_);
        ANTIQUE_COLORS.put((Object)MapColor.f_283818_, (Object)MapColor.f_283748_);
        ANTIQUE_COLORS.put((Object)MapColor.f_283771_, (Object)MapColor.f_283771_);
        ANTIQUE_COLORS.put((Object)MapColor.f_283927_, (Object)MapColor.f_283771_);
        ANTIQUE_COLORS.put((Object)MapColor.f_283761_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.f_283942_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.f_283811_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.f_283906_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.f_283930_, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.f_283748_, (Object)MapColor.f_283774_);
    }

    public static class WeatheredMapData
    implements CustomMapData<CustomMapData.SimpleDirtyCounter> {
        private boolean antique = false;

        public boolean isAntique() {
            return this.antique;
        }

        public void load(CompoundTag tag) {
            this.antique = tag.m_128441_(WeatheredMap.ANTIQUE_KEY) ? tag.m_128471_(WeatheredMap.ANTIQUE_KEY) : false;
        }

        public void loadUpdateTag(CompoundTag tag) {
            if (tag.m_128441_(WeatheredMap.ANTIQUE_KEY)) {
                this.antique = tag.m_128471_(WeatheredMap.ANTIQUE_KEY);
            }
        }

        public void save(CompoundTag tag) {
            if (this.antique) {
                tag.m_128379_(WeatheredMap.ANTIQUE_KEY, true);
            }
        }

        public void saveToUpdateTag(CompoundTag tag, CustomMapData.SimpleDirtyCounter dirtyCounter) {
            tag.m_128379_(WeatheredMap.ANTIQUE_KEY, this.antique);
        }

        public CustomMapData.Type<WeatheredMapData> getType() {
            return ANTIQUE_DATA_KEY;
        }

        @Nullable
        public Component onItemTooltip(MapItemSavedData data, ItemStack stack) {
            if (this.antique) {
                return Component.m_237115_((String)"filled_map.antique.tooltip").m_130940_(ChatFormatting.GRAY);
            }
            return null;
        }

        public CustomMapData.SimpleDirtyCounter createDirtyCounter() {
            return new CustomMapData.SimpleDirtyCounter();
        }

        public boolean onItemUpdate(MapItemSavedData data, Entity entity) {
            boolean hasCeiling;
            boolean hasDepthLock;
            if (!this.antique) {
                return false;
            }
            Level level = entity.m_9236_();
            if (level.m_46472_() != data.f_77887_ || !(entity instanceof Player)) {
                return true;
            }
            Player pl = (Player)entity;
            int minHeight = SliceMapItem.getMapHeight(data);
            boolean bl = hasDepthLock = minHeight != Integer.MAX_VALUE;
            if (hasDepthLock && !SliceMapItem.canPlayerSee(minHeight, (Entity)pl)) {
                return true;
            }
            int scale = 1 << data.f_77890_;
            int mapX = data.f_256718_;
            int mapZ = data.f_256789_;
            int playerX = Mth.m_14107_((double)(entity.m_20185_() - (double)mapX)) / scale + 64;
            int playerZ = Mth.m_14107_((double)(entity.m_20189_() - (double)mapZ)) / scale + 64;
            int range = 128 / scale;
            if (hasDepthLock) {
                range = (int)((double)range * SliceMapItem.getRangeMultiplier());
            }
            if (hasCeiling = WeatheredMapData.isHasCeiling(level, minHeight)) {
                range /= 2;
            }
            MapItemSavedData.HoldingPlayer player = data.m_77916_((Player)entity);
            boolean hasChangedAColorThisZ = false;
            for (int pixelX = playerX - range + 1; pixelX < playerX + range; ++pixelX) {
                if ((pixelX & 0xF) != (player.f_77960_ & 0xF) && !hasChangedAColorThisZ) continue;
                hasChangedAColorThisZ = false;
                double somethingY = 0.0;
                for (int pixelZ = playerZ - range - 1; pixelZ < playerZ + range; ++pixelZ) {
                    LevelChunk lc;
                    boolean maxRadius;
                    if (pixelX < 0 || pixelZ < -1 || pixelX >= 128 || pixelZ >= 128) continue;
                    int offsetX = pixelX - playerX;
                    int offsetZ = pixelZ - playerZ;
                    int dist = offsetX * offsetX + offsetZ * offsetZ;
                    boolean bl2 = maxRadius = dist > range * range;
                    if (maxRadius) continue;
                    boolean innerRadius = dist > (range - 2) * (range - 2);
                    int worldX = (mapX / scale + pixelX - 64) * scale;
                    int worldZ = (mapZ / scale + pixelZ - 64) * scale;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    ChunkAccess levelchunk = level.m_6522_(SectionPos.m_123171_((int)worldX), SectionPos.m_123171_((int)worldZ), ChunkStatus.f_62326_, false);
                    if (!(levelchunk instanceof LevelChunk) || (lc = (LevelChunk)levelchunk).m_6430_()) continue;
                    ChunkPos chunkpos = levelchunk.m_7697_();
                    int chunkCoordX = worldX & 0xF;
                    int chunkCoordZ = worldZ & 0xF;
                    double maxY = 0.0;
                    int distanceFromLand = 8;
                    HashMap<BlockPos, Boolean> isWaterMap = new HashMap<BlockPos, Boolean>();
                    if (hasCeiling) {
                        int l3 = worldX + worldZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.f_50493_.m_49966_().m_284242_((BlockGetter)level, BlockPos.f_121853_), 10);
                        } else {
                            multiset.add((Object)Blocks.f_50106_.m_49966_().m_284242_((BlockGetter)level, BlockPos.f_121853_), 100);
                        }
                        maxY = 100.0;
                        distanceFromLand = 0;
                    } else {
                        BlockPos.MutableBlockPos mutable1 = new BlockPos.MutableBlockPos();
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ - scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ + scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ - scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ + scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX, worldZ - scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX, worldZ + scale)) {
                            --distanceFromLand;
                        }
                        for (int scaleOffsetX = 0; scaleOffsetX < scale; ++scaleOffsetX) {
                            for (int scaleOffsetZ = 0; scaleOffsetZ < scale; ++scaleOffsetZ) {
                                int cY = Math.min(minHeight, levelchunk.m_5885_(Heightmap.Types.WORLD_SURFACE, scaleOffsetX + chunkCoordX, scaleOffsetZ + chunkCoordZ) + 1);
                                MapColor newColor = null;
                                if (cY <= level.m_141937_() + 1) {
                                    newColor = Blocks.f_50752_.m_49966_().m_284242_((BlockGetter)level, (BlockPos)mutable1);
                                } else {
                                    BlockState blockState;
                                    MapColor temp;
                                    do {
                                        mutable1.m_122178_(chunkpos.m_45604_() + scaleOffsetX + chunkCoordX, --cY, chunkpos.m_45605_() + scaleOffsetZ + chunkCoordZ);
                                        blockState = levelchunk.m_8055_((BlockPos)mutable1);
                                        temp = blockState.m_284242_((BlockGetter)level, (BlockPos)mutable1);
                                        if (temp == MapColor.f_283808_ || temp == MapColor.f_283864_ || !blockState.m_60812_((BlockGetter)level, (BlockPos)mutable1).m_83281_()) continue;
                                        newColor = MapColor.f_283824_;
                                    } while (temp == MapColor.f_283808_ && cY > level.m_141937_());
                                    if (newColor == null) {
                                        newColor = blockState.m_284242_((BlockGetter)level, (BlockPos)mutable1);
                                    }
                                }
                                data.m_77930_((BlockGetter)level, chunkpos.m_45604_() + scaleOffsetX + chunkCoordX, chunkpos.m_45605_() + scaleOffsetZ + chunkCoordZ);
                                maxY += (double)cY / (double)(scale * scale);
                                if (cY >= minHeight) {
                                    newColor = SliceMapItem.getCutoffColor((BlockPos)mutable1, (BlockGetter)levelchunk);
                                }
                                multiset.add((Object)newColor);
                            }
                        }
                    }
                    int relativeShade = 1;
                    MapColor mc = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.f_283808_);
                    if (mc == MapColor.f_283864_) {
                        mc = MapColor.f_283750_;
                        if (distanceFromLand > 7 && pixelZ % 2 == 0) {
                            relativeShade = (pixelX + (int)(Mth.m_14031_((float)((float)pixelZ + 0.0f)) * 7.0f)) / 8 % 5;
                            if (relativeShade == 3) {
                                relativeShade = 1;
                            } else if (relativeShade == 4) {
                                relativeShade = 0;
                            }
                        } else if (distanceFromLand > 7) {
                            mc = ANTIQUE_LIGHT;
                            relativeShade = 2;
                        } else if (distanceFromLand > 5) {
                            relativeShade = 1;
                        } else if (distanceFromLand > 3) {
                            relativeShade = 0;
                        }
                    } else if (distanceFromLand > 0) {
                        relativeShade = 3;
                        mc = MapColor.f_283748_;
                        if (distanceFromLand > 3) {
                            relativeShade = 1;
                        }
                    } else {
                        double depthY = (maxY - somethingY) * 4.0 / (double)(scale + 4) + ((double)(pixelX + pixelZ & 1) - 0.5) * 0.4;
                        if (depthY > 0.6) {
                            relativeShade = 2;
                        } else if (depthY < -0.6) {
                            relativeShade = 0;
                        }
                        mc = (MapColor)ANTIQUE_COLORS.getOrDefault((Object)mc, (Object)ANTIQUE_DARK);
                    }
                    somethingY = maxY;
                    if (pixelZ < 0 || innerRadius && (pixelX + pixelZ & 1) == 0) continue;
                    hasChangedAColorThisZ |= data.m_164792_(pixelX, pixelZ, (byte)(mc.f_283805_ * 4 + relativeShade));
                }
            }
            ++player.f_77960_;
            return true;
        }

        private static boolean isHasCeiling(Level level, int mapHeight) {
            boolean original = level.m_6042_().f_63856_();
            if (original && mapHeight != Integer.MAX_VALUE && CommonConfigs.Tools.SLICE_MAP_ENABLED.get().booleanValue()) {
                return false;
            }
            return original;
        }

        public void set(boolean on) {
            this.antique = on;
        }

        private static boolean isWaterAt(Level level, Map<BlockPos, Boolean> map, int scale, int x, int z) {
            BlockPos pos = new BlockPos(x, 0, z);
            return map.computeIfAbsent(pos, p -> {
                int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z) - 1;
                return level.m_6425_(pos.m_6630_(y)).m_76178_();
            });
        }
    }
}

