/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.MultiLineEditBoxWidget;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.PlayerSuggestionBoxWidget;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.PresentContainerMenu;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetPresentPacket;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PresentScreen
extends AbstractContainerScreen<PresentContainerMenu>
implements ContainerListener {
    private static final int DESCRIPTION_BOX_X = 53;
    private static final int DESCRIPTION_BOX_Y = 33;
    private static final int DESCRIPTION_BOX_H = 36;
    private static final int DESCRIPTION_BOX_W = 105;
    private static final int SUGGESTION_BOX_Y = 19;
    private static final int SUGGESTION_BOX_W = 99;
    private static final int SUGGESTION_BOX_H = 12;
    private final PresentBlockTile tile;
    private PackButton packButton;
    private PlayerSuggestionBoxWidget recipient;
    private MultiLineEditBoxWidget descriptionBox;
    private boolean packed;
    private boolean needsInitialization = true;

    public PresentScreen(PresentContainerMenu menu, Inventory inventory, Component text) {
        super((AbstractContainerMenu)menu, inventory, text);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.tile = (PresentBlockTile)menu.getContainer();
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.packButton = (PackButton)this.m_142416_((GuiEventListener)new PackButton(i + 14, j + 45));
        this.recipient = (PlayerSuggestionBoxWidget)this.m_142416_((GuiEventListener)new PlayerSuggestionBoxWidget(this.f_96541_, i + 53, j + 19, 99, 12));
        this.recipient.setOutOfBoundResponder(up -> {
            if (!up.booleanValue()) {
                this.m_7522_((GuiEventListener)this.descriptionBox);
                this.recipient.m_93692_(false);
                this.descriptionBox.m_93692_(true);
            }
        });
        this.descriptionBox = (MultiLineEditBoxWidget)this.m_142416_((GuiEventListener)new MultiLineEditBoxWidget(this.f_96541_, i + 53, j + 33, 105, 36));
        this.descriptionBox.setOutOfBoundResponder(up -> {
            if (up.booleanValue()) {
                this.m_7522_((GuiEventListener)this.recipient);
                this.recipient.m_93692_(true);
                this.descriptionBox.m_93692_(false);
            }
        });
        this.m_7522_((GuiEventListener)this.recipient);
        this.recipient.setText(this.tile.getRecipient());
        this.descriptionBox.setText(this.tile.getDescription());
        this.packed = this.tile.isPacked();
        this.updateState();
        ((PresentContainerMenu)this.f_97732_).m_38893_(this);
    }

    public void onAddPlayer(PlayerInfo info) {
        this.recipient.addPlayer(info);
    }

    public void onRemovePlayer(UUID uuid) {
        this.recipient.removePlayer(uuid);
    }

    private void pack() {
        this.updateStateAndTryToPack(true);
    }

    private void updateState() {
        this.updateStateAndTryToPack(false);
    }

    private void updateStateAndTryToPack(boolean tryToPack) {
        boolean hasItem = this.needsInitialization ? this.packed : ((PresentContainerMenu)this.f_97732_).m_38853_(0).m_6657_();
        boolean hasChanged = false;
        if (this.packed && !hasItem) {
            this.packed = false;
            hasChanged = true;
        } else if (tryToPack && !this.packed && hasItem) {
            this.packed = true;
            hasChanged = true;
        }
        if (hasChanged) {
            String sender = Minecraft.m_91087_().f_91074_.m_7755_().getString();
            String recipient = this.recipient.getText();
            String description = this.descriptionBox.getText();
            NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundSetPresentPacket(this.tile.m_58899_(), this.packed, recipient, sender, description));
            this.tile.updateState(this.packed, recipient, sender, description);
            if (this.packed) {
                this.f_96541_.f_91074_.m_108763_();
            }
        }
        this.recipient.setState(hasItem, this.packed);
        this.packButton.setState(hasItem, this.packed);
        this.descriptionBox.setState(hasItem, this.packed);
    }

    public void m_7934_(AbstractContainerMenu container, int slot, ItemStack stack) {
        if (slot == 0) {
            this.updateState();
        }
    }

    public void m_142153_(AbstractContainerMenu container, int dataSlotIndex, int value) {
        this.m_7934_(container, 0, container.m_38853_(0).m_7993_());
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.m_280273_(graphics);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        ResourceLocation presentGuiTexture = ((PresentContainerMenu)this.f_97732_).m_38853_(0).m_7993_().m_41619_() ? ModTextures.PRESENT_EMPTY_GUI_TEXTURE : ModTextures.PRESENT_GUI_TEXTURE;
        graphics.m_280218_(presentGuiTexture, k, l, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.packed) {
            int k = (this.f_96543_ - this.f_97726_) / 2;
            int l = (this.f_96544_ - this.f_97727_) / 2;
            Slot slot = ((PresentContainerMenu)this.f_97732_).m_38853_(0);
            graphics.m_280398_(ModTextures.PRESENT_GUI_TEXTURE, k + slot.f_40220_, l + slot.f_40221_, 300, 12.0f, 232.0f, 16, 16, 256, 256);
        }
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics poseStack, int x, int y) {
        super.m_280003_(poseStack, x, y);
    }

    public boolean m_6375_(double mouseX, double mouseY, int key) {
        this.recipient.m_93692_(false);
        this.descriptionBox.m_93692_(false);
        return super.m_6375_(mouseX, mouseY, key);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return this.recipient.m_6050_(mouseX, mouseY, amount) || this.descriptionBox.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int key, int a, int b) {
        if (key == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return this.recipient.m_7933_(key, a, b) || this.recipient.canConsumeInput() || this.descriptionBox.m_7933_(key, a, b) || this.descriptionBox.canConsumeInput() || super.m_7933_(key, a, b);
    }

    public boolean m_7979_(double dx, double dy, int key, double mouseX, double mouseY) {
        if (key == 0 && this.descriptionBox.m_7979_(dx, dy, key, mouseX, mouseY)) {
            return true;
        }
        return super.m_7979_(dx, dy, key, mouseX, mouseY);
    }

    public void m_181908_() {
        this.needsInitialization = false;
        super.m_181908_();
        this.recipient.tick();
        this.descriptionBox.tick();
    }

    public void m_7861_() {
        super.m_7861_();
        ((PresentContainerMenu)this.f_97732_).m_38943_(this);
    }

    public class PackButton
    extends AbstractButton {
        private static final Tooltip TOOLTIP = Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.supplementaries.present.pack"));
        private boolean packed;

        protected PackButton(int x, int y) {
            super(x, y, 22, 22, CommonComponents.f_237098_);
        }

        public void m_87963_(GuiGraphics graphics, int i1, int i2, float v) {
            int i = 198;
            int j = 0;
            if (!this.f_93623_) {
                j += this.f_93618_ * 2;
            } else if (this.packed) {
                j += this.f_93618_ * 1;
            } else if (this.f_93622_) {
                j += this.f_93618_ * 3;
            }
            graphics.m_280218_(ModTextures.PRESENT_GUI_TEXTURE, this.m_252754_(), this.m_252907_(), j, i, this.f_93618_, this.f_93619_);
        }

        public void setState(boolean hasItem, boolean packed) {
            this.packed = packed;
            this.f_93623_ = hasItem;
            this.m_257544_((Tooltip)(!packed ? TOOLTIP : null));
        }

        protected ClientTooltipPositioner m_262860_() {
            return DefaultTooltipPositioner.f_262752_;
        }

        public void m_5691_() {
            PresentScreen.this.pack();
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        }
    }
}

