/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.hands;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.util.DamageSourceHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;

public class VampiricGloveItem
extends WearableArtifactItem {
    @Override
    protected boolean isCosmetic() {
        return ModGameRules.VAMPIRIC_GLOVE_ABSORPTION_RATIO.get() <= 0 || ModGameRules.VAMPIRIC_GLOVE_MAX_HEALING_PER_HIT.get() <= 0 || ModGameRules.VAMPIRIC_GLOVE_ABSORPTION_CHANCE.get() <= 0;
    }

    public static void onLivingDamage(LivingEntity entity, DamageSource damageSource, float amount) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && ModItems.VAMPIRIC_GLOVE.get().isEquippedBy(attacker) && DamageSourceHelper.isMeleeAttack(damageSource)) {
            int maxHealthAbsorbed = ModGameRules.VAMPIRIC_GLOVE_MAX_HEALING_PER_HIT.get();
            float absorptionRatio = (float)ModGameRules.VAMPIRIC_GLOVE_ABSORPTION_RATIO.get().intValue() / 100.0f;
            float absorptionProbability = (float)ModGameRules.VAMPIRIC_GLOVE_ABSORPTION_CHANCE.get().intValue() / 100.0f;
            float damageDealt = Math.min(amount, entity.m_21223_());
            float damageAbsorbed = Math.min((float)maxHealthAbsorbed, absorptionRatio * damageDealt);
            if (damageAbsorbed > 0.0f && entity.m_217043_().m_188501_() < absorptionProbability) {
                attacker.m_5634_(damageAbsorbed);
            }
        }
    }
}

