/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item.model;

import artifacts.client.item.ArtifactLayers;
import artifacts.client.item.RendererUtil;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class ArmsModel
extends HumanoidModel<LivingEntity> {
    public ArmsModel(ModelPart part, Function<ResourceLocation, RenderType> renderType) {
        super(part, renderType);
    }

    public ArmsModel(ModelPart part) {
        this(part, RenderType::m_110458_);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102812_, (Object)this.f_102811_);
    }

    public void renderArm(HumanoidArm handSide, PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_102851_((HumanoidArm)handSide).f_104207_ = true;
        this.m_102851_((HumanoidArm)handSide.m_20828_()).f_104207_ = false;
        this.m_7695_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public static ArmsModel createClawsModel(boolean smallArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.claws(smallArms)));
    }

    public static ArmsModel createGloveModel(boolean smallArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.glove(smallArms)));
    }

    public static ArmsModel createGoldenHookModel(boolean smallArms) {
        return new ArmsModel(RendererUtil.bakeLayer(ArtifactLayers.goldenHook(smallArms)));
    }

    public static MeshDefinition createEmptyArms(CubeListBuilder leftArm, CubeListBuilder rightArm, boolean smallArms) {
        MeshDefinition mesh = ArmsModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        mesh.m_171576_().m_171599_("left_arm", leftArm, PartPose.m_171419_((float)5.0f, (float)(smallArms ? 2.5f : 2.0f), (float)0.0f));
        mesh.m_171576_().m_171599_("right_arm", rightArm, PartPose.m_171419_((float)-5.0f, (float)(smallArms ? 2.5f : 2.0f), (float)0.0f));
        return mesh;
    }

    public static MeshDefinition createArms(CubeListBuilder leftArm, CubeListBuilder rightArm, boolean smallArms) {
        leftArm.m_171514_(0, 0);
        rightArm.m_171514_(16, 0);
        ArmsModel.addArms(leftArm, rightArm, new CubeDeformation(0.5f), smallArms);
        return ArmsModel.createEmptyArms(leftArm, rightArm, smallArms);
    }

    public static MeshDefinition createSleevedArms(CubeListBuilder leftArm, CubeListBuilder rightArm, boolean smallArms) {
        leftArm.m_171514_(0, 16);
        rightArm.m_171514_(16, 16);
        ArmsModel.addArms(leftArm, rightArm, new CubeDeformation(0.75f), smallArms);
        return ArmsModel.createArms(leftArm, rightArm, smallArms);
    }

    public static MeshDefinition createSleevedArms(boolean smallArms) {
        return ArmsModel.createSleevedArms(CubeListBuilder.m_171558_(), CubeListBuilder.m_171558_(), smallArms);
    }

    private static void addArms(CubeListBuilder leftArm, CubeListBuilder rightArm, CubeDeformation deformation, boolean smallArms) {
        leftArm.m_171488_(-1.0f, -2.0f, -2.0f, smallArms ? 3.0f : 4.0f, 12.0f, 4.0f, deformation);
        rightArm.m_171488_(smallArms ? -2.0f : -3.0f, -2.0f, -2.0f, smallArms ? 3.0f : 4.0f, 12.0f, 4.0f, deformation);
    }

    public static MeshDefinition createClaws(boolean smallArms) {
        CubeListBuilder leftArm = CubeListBuilder.m_171558_();
        CubeListBuilder rightArm = CubeListBuilder.m_171558_();
        int smallArmsOffset = smallArms ? 1 : 0;
        leftArm.m_171514_(0, 0);
        leftArm.m_171481_((float)(-smallArmsOffset), 10.0f, -1.5f, 3.0f, 5.0f, 1.0f);
        rightArm.m_171514_(8, 0);
        rightArm.m_171481_((float)(-3 + smallArmsOffset), 10.0f, -1.5f, 3.0f, 5.0f, 1.0f);
        leftArm.m_171514_(0, 6);
        leftArm.m_171481_((float)(-smallArmsOffset), 10.0f, 0.5f, 3.0f, 5.0f, 1.0f);
        rightArm.m_171514_(8, 6);
        rightArm.m_171481_((float)(-3 + smallArmsOffset), 10.0f, 0.5f, 3.0f, 5.0f, 1.0f);
        leftArm.m_171514_(16, 0);
        leftArm.m_171481_((float)(3 - smallArmsOffset), 10.0f, -1.5f, 1.0f, 4.0f, 1.0f);
        rightArm.m_171514_(20, 0);
        rightArm.m_171481_((float)(-4 + smallArmsOffset), 10.0f, -1.5f, 1.0f, 4.0f, 1.0f);
        leftArm.m_171514_(16, 6);
        leftArm.m_171481_((float)(3 - smallArmsOffset), 10.0f, 0.5f, 1.0f, 4.0f, 1.0f);
        rightArm.m_171514_(20, 6);
        rightArm.m_171481_((float)(-4 + smallArmsOffset), 10.0f, 0.5f, 1.0f, 4.0f, 1.0f);
        return ArmsModel.createEmptyArms(leftArm, rightArm, smallArms);
    }

    public static MeshDefinition createGoldenHook(boolean smallArms) {
        CubeListBuilder leftArm = CubeListBuilder.m_171558_();
        CubeListBuilder rightArm = CubeListBuilder.m_171558_();
        leftArm.m_171514_(32, 0);
        leftArm.m_171481_(smallArms ? -2.0f : -1.5f, 12.0f, -0.5f, 5.0f, 5.0f, 1.0f);
        rightArm.m_171514_(48, 0);
        rightArm.m_171481_(smallArms ? -3.0f : -3.5f, 12.0f, -0.5f, 5.0f, 5.0f, 1.0f);
        leftArm.m_171514_(32, 6);
        leftArm.m_171481_(smallArms ? 0.0f : 0.5f, 10.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        rightArm.m_171514_(48, 6);
        rightArm.m_171481_(smallArms ? -1.0f : -1.5f, 10.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        return ArmsModel.createSleevedArms(leftArm, rightArm, smallArms);
    }
}

